package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 车主运单计费明细
* @Date: 2023/10/11 17:46:48
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class SettlementDriverDetail implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long driverUserNo;                      //车主用户编号
    private String driverName;                      //车主名称
    private String settlementNo;                    //结算单号
    private String childNo;                         //运单编号
    private String orderGoodsNo;                    //货单编号
    private String orderNo;                         //订单编号
    private Integer goodsId;                        //货物id
    private String goodsName;                       //货物名称
    private String truckNo;                         //车牌号
    private BigDecimal weight;                      //拉运重量（单位吨）
    private BigDecimal freightPrice;                //运费单价（分）
    private BigDecimal freight;                     //实际运费（分）
    private BigDecimal lossPrice;                   //损耗单价（分）
    private BigDecimal lossWeight;                  //货损吨数
    private BigDecimal lossFreight;                 //货损金额（分）
    private BigDecimal prepayFreight;               //预付运费金额（分）
    private Integer prepayFreightFlag;              //预付运费标示  0:未预付 1：已预付
    private Integer loanFlag;                       //借款标示  0：未借款 1：已借款 2:已还款
    private Integer loanTypeFlag;                   //借款类型标示  0：虚拟货币+资金 1：虚拟货币 2：资金
    private BigDecimal settlementFreight;           //结算金额（分）
    private Integer invoiceType;                    //开票标识：1网运单 2普通单
    private Integer invoicingCompanyId;             //开票公司id
    private String invoicingCompanyShorterName;     //开票公司简称
    private String invoicingCompanyGroupCode;  //开票公司统一社会信用代码
    private BigDecimal platformServiceFee;           //平台服务费（分）
    private BigDecimal platformServiceFeeRate;       //平台服务费费率%
    private Integer payAcceptStatus;                 //支付受理状态：0未受理支付 1支付受理中 2已受理支付
    private Integer status;                         //状态
    private LocalDateTime createTime;                      //创建时间
    private LocalDateTime modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}