package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-12-08
 * Time 11:42
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_child_sync_transport_record")
public class OrderChildSyncTransportRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("driver_user_no")
    @Schema(description="车主用户编号")
    private Long driverUserNo;

    @TableField("driver_name")
    @Schema(description="车主名称")
    private String driverName;

    @TableField("settlement_no")
    @Schema(description="结算单号")
    private String settlementNo;

    @TableField("child_no")
    @Schema(description="运单编号")
    private String childNo;

    @TableField("order_goods_no")
    @Schema(description="货单编号")
    private String orderGoodsNo;

    @TableField("order_no")
    @Schema(description="订单编号")
    private String orderNo;

    @TableField("goods_id")
    @Schema(description="货物id")
    private Integer goodsId;

    @TableField("goods_name")
    @Schema(description="货物名称")
    private String goodsName;

    @TableField("truck_no")
    @Schema(description="车牌号")
    private String truckNo;

    @TableField("weight")
    @Schema(description="拉运重量（单位吨）")
    private BigDecimal weight;

    @TableField("freight_price")
    @Schema(description="运费单价（分）")
    private BigDecimal freightPrice;

    @TableField("freight")
    @Schema(description="实际运费（分）")
    private BigDecimal freight;

    @TableField("loss_price")
    @Schema(description="损耗单价（分）")
    private BigDecimal lossPrice;

    @TableField("loss_weight")
    @Schema(description="货损吨数")
    private BigDecimal lossWeight;

    @TableField("loss_freight")
    @Schema(description="货损金额（分）")
    private BigDecimal lossFreight;

    @TableField("prepay_freight")
    @Schema(description="预付运费金额（分）")
    private BigDecimal prepayFreight;

    @TableField("prepay_freight_flag")
    @Schema(description="预付运费标示  0:未预付 1：已预付")
    private Integer prepayFreightFlag;

    @TableField("settlement_freight")
    @Schema(description="结算金额（分）")
    private BigDecimal settlementFreight;

    @TableField("invoice_type")
    @Schema(description="开票标识：1网运单 2普通单")
    private Integer invoiceType;

    @TableField("status")
    @Schema(description="状态 0： 未同步， 1：已同步 2：回调成功 3：回调失败")
    private Integer status;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
