package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_loan_account_running_water_record")
public class OwnerLoanAccountRunningWaterRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    
    @TableField("owner_user_no")
    @Schema(description="货主编码")
    private Long ownerUserNo;

    
    @TableField("owner_user_name")
    @Schema(description="货主名称")
    private String ownerUserName;

    
    @TableField("mobile")
    @Schema(description="联系电话")
    private String mobile;

    
    @TableField("running_water_no")
    @Schema(description="流水号")
    private Long runningWaterNo;

    
    @TableField("loan_no")
    @Schema(description="借款单号")
    private Long loanNo;

    @TableField("loan_type")
    @Schema(description="借款类型 1：虚拟货币 2：资金")
    private Integer loanType;

    
    @TableField("child_no")
    @Schema(description="运单编号")
    private String childNo;

    
    @TableField("running_water_type")
    @Schema(description="流水类型 70：运单核销 80：借款")
    private Integer runningWaterType;

    
    @TableField("alteration_balance")
    @Schema(description="金额")
    private BigDecimal alterationBalance;

    @TableField("use_able_balance")
    @Schema(description="可用余额")
    private BigDecimal useAbleBalance;

    @TableField("frozen_balance")
    @Schema(description="冻结余额")
    private BigDecimal frozenBalance;

    @TableField("account_balance")
    @Schema(description="账户余额")
    private BigDecimal accountBalance;

    
    @TableField("create_by")
    @Schema(description="创建人")
    private String createBy;

    
    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
