package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 借款配置
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class BorrowerConfig implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Integer borrowerId;                     //借出方id
    private String borrowerName;                    //借出方
    private Integer type;                           //类型：1虚拟货币 2 资金
    private Integer day;                            //借款天数
    private Integer deleteStatus;                   //删除状态: 0-否;1-是
    private Integer status;                         //状态：1启用 2禁用
    private Long opUserNo;                          //操作人编码
    private String opUserName;                      //操作人
    private LocalDateTime opTime;                   //操作时间
    private Long createBy;                          //创建人编号
    private String createName;                      //创建人名称
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}