package com.clx.performance.model.export;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

@Getter
@Setter
@Accessors(chain = true)
@TableName("export_field")
public class ExportField implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;


    @TableField("export_function_code")
    @Schema(description="功能code")
    private String exportFunctionCode;

    @TableField("name")
    @Schema(description="字段名称")
    private String name;

    @TableField("code")
    @Schema(description="字段code,用于映射真实数据字段")
    private String code;

    @TableField("required")
    @Schema(description="是否必填：1是，0否")
    private Integer required;

    @TableField("sort")
    @Schema(description="排序字段")
    private Integer sort;

    @TableField("remark")
    @Schema(description="字段描述")
    private String remark;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
