package com.clx.performance.model.breakcontract;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("break_contract_settlement_log")
public class BreakContractSettlementLog  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("settlement_no")
    @Schema(description="结算单编号")
    private String settlementNo;

    @TableField("type")
    @Schema(description="类型")
    private Integer type;

    @TableField("remark")
    @Schema(description="内容")
    private String remark;

    @TableField("create_type")
    @Schema(description="操作人类型1-货主， 2-承运端，3-司机")
    private Integer createType;

    @TableField("create_by")
    @Schema(description="操作人编号")
    private Long createBy;

    @TableField("create_name")
    @Schema(description="操作人名称")
    private String createName;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
