package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-11-28
 * Time 17:42
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_account_password")
@Builder
public class OwnerAccountPassword implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("user_no")
    @Schema(description="")
    private Long userNo;

    @TableField("password")
    @Schema(description="交易密码")
    private String password;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
