package com.clx.performance.mapper.integral;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.integral.IntegralTruckRule;
import com.clx.performance.param.pc.integral.PageIntegralTruckRuleParam;
import com.clx.performance.sqlProvider.integral.IntegralTruckRuleProvider;
import com.clx.performance.vo.pc.integral.AppIntegralTruckRuleVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

/**
* @Author: aiqinguo
* @Description: 积分车辆规则
* @Date: 2023-10-9 11:52:22
* @Version: 1.0
*/

@Mapper
public interface IntegralTruckRuleMapper extends BaseMapper<IntegralTruckRule> {

    /**
     * @see IntegralTruckRuleProvider#pageRule(com.baomidou.mybatisplus.extension.plugins.pagination.Page, PageIntegralTruckRuleParam)
     */
    @SelectProvider(type = IntegralTruckRuleProvider.class, method = "pageRule")
    IPage<AppIntegralTruckRuleVO> pageRule(@Param("page") Page<AppIntegralTruckRuleVO> page, @Param("param") PageIntegralTruckRuleParam param);


}