package com.clx.performance.job;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.clx.performance.dao.breakcontract.BreakContractOwnerRecordDao;
import com.clx.performance.enums.BreakContractOwnerRecordEnum;
import com.clx.performance.model.breakcontract.BreakContractOwnerRecord;
import com.clx.performance.service.breakcontract.BreakContractOwnerRecordService;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Component
public class OwnerBreakContractSettlementJob {

    @Autowired
    private BreakContractOwnerRecordService breakContractOwnerRecordService;


    @Autowired
    private BreakContractOwnerRecordDao breakContractOwnerRecordDao;

    /**
     * 如果货主2天都未确认，系统自动确认
     */
    @XxlJob("autoConfirmOwnerBreakSettle")
    @Transactional(rollbackFor = Exception.class)
    public void autoConfirmOwnerBreakSettle() {
        try {
            List<BreakContractOwnerRecord> ownerRecords = breakContractOwnerRecordDao.ownerNoConfirmTwoDaysList(LocalDateTime.now());
            if(CollectionUtils.isNotEmpty(ownerRecords)){
                for(BreakContractOwnerRecord record :ownerRecords){
                    breakContractOwnerRecordService.generateBreakContractSettlement(record.getId());
                    record.setConfirmStatus(BreakContractOwnerRecordEnum.ConfirmStatus.CONFIRMED.getCode());
                    breakContractOwnerRecordDao.updateConfirmStatus(record);
                }
            }
        } catch (Exception e) {
            log.warn("违约结算单系统自动确认，异常原因:{}",e);
        }
    }



}
