package com.clx.performance.dao.impl.export;

import com.clx.performance.dao.export.ExportFieldDao;
import com.clx.performance.mapper.export.ExportFieldMapper;
import com.clx.performance.model.export.ExportField;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import com.msl.common.enums.WhetherEnum;
import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.List;

@Repository
public class ExportFieldDaoImpl extends BaseDaoImpl<ExportFieldMapper, ExportField, Integer> implements ExportFieldDao {

    @Override
    public List<ExportField> listFieldByTemplate(Integer templateId) {
        return Optional.ofNullable(templateId).map(baseMapper::listFieldByTemplate).orElse(Collections.emptyList());
    }

    @Override
    public List<ExportField> listFieldByFunctionCode(String functionCode) {
        return Optional.ofNullable(functionCode)
                .map(code -> lQrWrapper().eq(ExportField::getExportFunctionCode, functionCode)
                        .orderByAsc(ExportField::getSort))
                .map(super::list)
                .orElse(Collections.emptyList());
    }

    @Override
    public List<ExportField> listRequiredFieldByFunctionCode(String functionCode) {
        return Optional.ofNullable(functionCode)
                .map(code -> lQrWrapper().eq(ExportField::getExportFunctionCode, functionCode)
                        .eq(ExportField::getRequired, WhetherEnum.get(true))
                        .orderByAsc(ExportField::getSort))
                .map(super::list)
                .orElse(Collections.emptyList());
    }
}
