package com.clx.performance.dao.impl.customer;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.customer.CustomerComplaintTypeDao;
import com.clx.performance.mapper.customer.CustomerComplaintTypeMapper;
import com.clx.performance.model.customer.CustomerComplaintType;
import com.clx.performance.param.pc.customer.PageCustomerComplaintTypeParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;

/**
 * @ClassName CustomerComplaintTypeDaoImpl
 * @Description
 * @Author kavin
 * @Date 2023/12/7 11:25
 * @Version 1.0
 */
@Repository
public class CustomerComplaintTypeDaoImpl extends BaseDaoImpl<CustomerComplaintTypeMapper, CustomerComplaintType, Integer> implements CustomerComplaintTypeDao {
    @Override
    public long countByNameExcludeSelf(String name, Integer id) {
        LambdaQueryWrapper<CustomerComplaintType> query = new LambdaQueryWrapper<>();
        query.eq(CustomerComplaintType :: getName,name);
        if(Objects.nonNull(id)){
            query.ne(CustomerComplaintType :: getId,id);
        }
        return baseMapper.selectCount(query);
    }

    @Override
    public Page<CustomerComplaintType> pageCustomerComplaintType(PageCustomerComplaintTypeParam param) {
        LambdaQueryWrapper<CustomerComplaintType> query = new LambdaQueryWrapper<>();
        if(StringUtils.isNotBlank(param.getName())){
            query.eq(CustomerComplaintType :: getName,param.getName());
        }
        query.orderByDesc(CustomerComplaintType :: getModifiedTime);
        return baseMapper.selectPage(Page.of(param.getPage(),param.getPageSize()),query);
    }

    @Override
    public List<CustomerComplaintType> getCustomerComplaintTypeSelect(PageCustomerComplaintTypeParam param) {
        LambdaQueryWrapper<CustomerComplaintType> query = new LambdaQueryWrapper<>();
        if(StringUtils.isNotBlank(param.getName())){
            query.eq(CustomerComplaintType :: getName,param.getName());
        }
        query.orderByDesc(CustomerComplaintType :: getModifiedTime);
        return baseMapper.selectList(query);
    }
}
