package com.clx.performance.controller.temp;

import com.clx.performance.service.vehiclewarn.VehicleWarnMqHandlerService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;


/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp/vehicleWarn")
public class TempVehicleWarnController {

    @Autowired
    private VehicleWarnMqHandlerService vehicleWarnMqHandlerService;

    @Operation(summary = "发送预警短信", description = "<br>By:艾庆国")
    @PostMapping("/sendSms")
    public Result sendSms(String mobile, String warnName, String truckNo, String childNo) {

        vehicleWarnMqHandlerService.sendSms(Arrays.asList(mobile), warnName, truckNo, childNo);

        return Result.ok();
    }

    @Operation(summary = "发送预警外呼", description = "<br>By:艾庆国")
    @PostMapping("/sendClink")
    public Result sendClink(String mobile, String warnName, String truckNo, String childNo) {
        vehicleWarnMqHandlerService.sendClink(Arrays.asList(mobile), warnName, truckNo, childNo);

        return Result.ok();
    }

}
