package com.clx.performance.controller.temp;

import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.listener.OrderChildSyncTransportListener;
import com.clx.performance.model.OrderChild;
import com.clx.performance.service.broker.OrderChildBrokerMqService;
import com.clx.performance.service.settle.SettlementMqHandlerService;
import com.clx.performance.service.settle.SettlementMqService;
import com.clx.performance.vo.mq.SettlementDetailAddMqParam;
import com.clx.performance.vo.mq.SettlementStatisticsMqParam;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp/settlement")
public class TempSettlementController {
    @Autowired
    private OrderChildDao orderChildDao;
    @Autowired
    private SettlementMqService settlementMqService;
    @Autowired
    private OrderChildSyncTransportListener orderChildSyncTransportListener;
    @Autowired
    private SettlementMqHandlerService settlementMqHandlerService;
    @Autowired
    private OrderChildBrokerMqService orderChildBrokerMqService;

    @Operation(summary = "settlementStatistics", description = "<br>By:艾庆国")
    @RequestMapping(value = "/settlementStatistics", method = RequestMethod.GET)
    public Result settlementStatistics(String childNo) {

        SettlementStatisticsMqParam mq = new SettlementStatisticsMqParam();
        mq.setChildNo(childNo);
        settlementMqHandlerService.settlementStatistics(mq);

        return Result.ok();
    }

    @Operation(summary = "结算单新增", description = "<br>By:艾庆国")
    @RequestMapping(value = "/settlementDetailAdd", method = RequestMethod.GET)
    public Result settlementDetailAdd(Integer settlementOwnerDetailId, Integer settlementDriverDetailId) {

//        SettlementDetailAddMqParam mq = new SettlementDetailAddMqParam();
//        mq.setSettlementOwnerDetailId(settlementOwnerDetailId);
//        mq.setSettlementDriverDetailId(settlementDriverDetailId);
//        settlementMqHandlerService.settlementDetailAdd(mq);

        settlementMqService.settlementDetailAdd(settlementDriverDetailId, settlementOwnerDetailId);

        return Result.ok();
    }
    @Operation(summary = "运单同步broker", description = "<br>By:艾庆国")
    @RequestMapping(value = "/orderChildSync", method = RequestMethod.GET)
    public Result orderChildSync(String childNo) {

        // 发送mq (更新无车承运)
        orderChildBrokerMqService.orderChildSync(childNo);

        return Result.ok();
    }
    @Operation(summary = "运单更新broker", description = "<br>By:艾庆国")
    @RequestMapping(value = "/orderChildUpdate", method = RequestMethod.GET)
    public Result orderChildUpdate(String childNo) {

        // 发送mq (更新无车承运)
        orderChildBrokerMqService.orderChildUpdate(childNo);

        return Result.ok();
    }

    @Operation(summary = "开票类型同步", description = "<br>By:艾庆国")
    @RequestMapping(value = "/invoiceTypeSync", method = RequestMethod.GET)
    public Result invoiceTypeSync(String childNo) {

        settlementMqService.invoiceTypeSync(childNo);

        return Result.ok();
    }

    @Operation(summary = "开票状态同步", description = "<br>By:艾庆国")
    @RequestMapping(value = "/invoiceStatusSync", method = RequestMethod.GET)
    public Result invoiceStatusSync(String childNo) {

        settlementMqService.invoiceStatusSync(childNo);

        return Result.ok();
    }
    @Operation(summary = "支付状态同步", description = "<br>By:艾庆国")
    @RequestMapping(value = "/payStatusSync", method = RequestMethod.GET)
    public Result payStatusSync(String childNo) {

        settlementMqService.payStatusSync(childNo);

        return Result.ok();
    }

    @Operation(summary = "开票公司更新", description = "<br>By:艾庆国")
    @RequestMapping(value = "/updateInvoiceCompany", method = RequestMethod.GET)
    public Result updateInvoiceCompany(Integer id) {

        // 发送mq （开票公司更新）
        settlementMqService.updateInvoiceCompany(id);

        return Result.ok();
    }

}
