package com.clx.performance.controller.pc.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnRangeParam;
import com.clx.performance.param.pc.vehiclewarn.VehicleWarnRangeResumeUpdateParam;
import com.clx.performance.param.pc.vehiclewarn.VehicleWarnRangeSuspendUpdateParam;
import com.clx.performance.service.vehiclewarn.VehicleWarnRangeService;
import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnRangDTO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotNull;

@Slf4j
@RestController
@Validated
@Tag(name = "车辆预警-预警暂停管理")
@RequestMapping(value="/pc/owner/vehicleWarnRange")
public class VehicleWarnRangeController {

    @Autowired
    private VehicleWarnRangeService vehicleWarnRangeService;

    @Operation(summary = "更新预警暂停", description = "<br>By:艾庆国")
    @PostMapping("/updateSuspend")
    public Result<Void> updateSuspend(@RequestBody @Validated VehicleWarnRangeSuspendUpdateParam param) {
        vehicleWarnRangeService.updateSuspend(param);
        return Result.ok();
    }

    @Operation(summary = "更新预警解除", description = "<br>By:艾庆国")
    @PostMapping("/updateResume")
    public Result<Void> updateResume(@RequestBody @Validated VehicleWarnRangeResumeUpdateParam param) {
        vehicleWarnRangeService.updateResume(param);
        return Result.ok();
    }

    @Operation(summary = "获取暂停信息",description = "<br>By:艾庆国")
    @GetMapping("/getRange")
    public Result<VehicleWarnRangDTO> getRange(@NotNull(message = "id不能为空") @Validated Integer id) {
        return Result.ok(vehicleWarnRangeService.getRange(id));
    }

    @Operation(summary = "分页搜索预警暂停列表",description = "<br>By:艾庆国")
    @PostMapping("/pageRange")
    public Result<PageData<VehicleWarnRangDTO>> pageRange(@RequestBody @Validated PageVehicleWarnRangeParam param) {
        IPage<VehicleWarnRangDTO> page = vehicleWarnRangeService.pageRange(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
