package com.clx.performance.controller.pc.loan.owner;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dto.OwnerLoanAccountRunWaterRecordDTO;
import com.clx.performance.param.pc.loan.owner.PageOwnerLoanRunWaterRecordParam;
import com.clx.performance.service.loan.OwnerLoanAccountRunningWaterRecordService;
import com.clx.performance.vo.pc.loan.owner.OwnerLoanRunWaterRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletResponse;
import java.util.List;

@Slf4j
@RestController
@RequestMapping(value="/pc/owner/loanRunWaterRecord")
@Validated
@Tag(name = "货主端-资金管理（货主借款账户管理（申请借款））")
@AllArgsConstructor
public class OwnerLoanAccountRunningWaterRecordController {

    private final OwnerLoanAccountRunningWaterRecordService ownerLoanAccountRunningWaterRecordService;


    @Operation(summary = "货主账户流水",description = "<br>By:刘海泉")
    @PostMapping("/pageOwnerLoanRunWaterRecord")
    @UnitCovert(param = false)
    public Result<PageData<OwnerLoanRunWaterRecordVO>> pageOwnerLoanRunWaterRecord(@RequestBody @Validated PageOwnerLoanRunWaterRecordParam param) {
        IPage<OwnerLoanRunWaterRecordVO> page  = ownerLoanAccountRunningWaterRecordService.pageOwnerLoanRunWaterRecord(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }


    @Operation(summary = "货主账户流水下载")
    @PostMapping("/exportOwnerLoanRunWaterRecord")
    public void exportOwnerLoanRunWaterRecord(@RequestBody @Validated PageOwnerLoanRunWaterRecordParam param, HttpServletResponse response) throws Exception {
        List<OwnerLoanAccountRunWaterRecordDTO> list = ownerLoanAccountRunningWaterRecordService.exportOwnerLoanRunWaterRecord(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        EasyExcel.write(response.getOutputStream(), OwnerLoanAccountRunWaterRecordDTO.class).sheet("账户流水").doWrite(list);
    }


}
