package com.clx.performance.controller.pc.customer;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.customer.PageCustomerComplaintTypeParam;
import com.clx.performance.param.pc.customer.SaveComplaintTypeParam;
import com.clx.performance.service.customer.CustomerComplaintTypeService;
import com.clx.performance.vo.pc.customer.CustomerComplaintTypeVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @ClassName CustomerComplaintTypeController
 * @Description
 * @Author kavin
 * @Date 2023/12/7 10:44
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/customer/complaint/type")
@Validated
@Tag(name = "客服-投诉分类")
@AllArgsConstructor
public class CustomerComplaintTypeController {

    private final CustomerComplaintTypeService customerComplaintTypeService;


    @Operation(summary = "保存/更新投诉分类",description = "<br>By:刘海泉")
    @PostMapping("/saveCustomerComplaintType")
    public Result<Object> saveCustomerComplaintType(@RequestBody @Validated SaveComplaintTypeParam param){
        customerComplaintTypeService.saveCustomerComplaintType(param);
        return Result.ok();
    }


    @Operation(summary = "投诉分类列表",description = "<br>By:刘海泉")
    @PostMapping("/pageCustomerComplaintType")
    public Result<PageData<CustomerComplaintTypeVO>> pageCustomerComplaintType(@RequestBody @Validated PageCustomerComplaintTypeParam param){
        IPage<CustomerComplaintTypeVO> page = customerComplaintTypeService.pageCustomerComplaintType(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @Operation(summary = "投诉分类下拉选",description = "<br>By:刘海泉")
    @PostMapping("/getCustomerComplaintTypeSelect")
    public Result<List<CustomerComplaintTypeVO>> getCustomerComplaintTypeSelect(@RequestBody @Validated PageCustomerComplaintTypeParam param){
        List<CustomerComplaintTypeVO> list = customerComplaintTypeService.getCustomerComplaintTypeSelect(param);
        return Result.ok(list);
    }


}
