package com.clx.performance.controller.pc.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckRefuelParam;
import com.clx.performance.service.collect.CollectTruckRefuelService;
import com.clx.performance.vo.pc.collect.CollectTruckRefuelVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/driver/collect/refuel")
@Validated
@Tag(name = "承运PC-油表上报")
@AllArgsConstructor
public class CarrierDriverCollectTruckRefuelController {

    private final CollectTruckRefuelService collectTruckRefuelService;

    @Operation(summary = "分页查询油表上报列表",description = "<br>By:艾庆国")
    @PostMapping("/pageRefuelReport")
    public Result<PageData<CollectTruckRefuelVO>> pageRefuelReport(@RequestBody @Validated CarrierPageCollectTruckRefuelParam param) {
        IPage<CollectTruckRefuelVO> page = collectTruckRefuelService.carrierPageRefuelReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
