package com.clx.performance.controller.pc.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.*;
import com.clx.performance.param.pc.carrier.*;
import com.clx.performance.service.collect.CollectLineReportService;
import com.clx.performance.vo.pc.collect.CollectLineReportVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/driver/collect/line")
@Validated
@Tag(name = "承运PC-线路上报")
@AllArgsConstructor
public class CarrierDriverCollectLineReportController {

    private final CollectLineReportService collectLineReportService;

    @Operation(summary = "分页查询货源地上报列表",description = "<br>By:艾庆国")
    @PostMapping("/pageSendAddressReport")
    public Result<PageData<CollectLineReportVO>> pageSendAddressReport(@RequestBody @Validated CarrierPageCollectSendAddressReportParam param) {
        IPage<CollectLineReportVO> page = collectLineReportService.carrierPageSendAddressReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "货源地上报审核", description = "<br>By:艾庆国")
    @PostMapping("/updateSendAddressReportAudit")
    public Result<Void> updateSendAddressReportAudit(@RequestBody @Validated CollectLineReportSendAddressAuditParam param) {
        collectLineReportService.updateSendAddressReportAudit(param);

        return Result.ok();
    }

    @Operation(summary = "分页查询异常上报列表",description = "<br>By:艾庆国")
    @PostMapping("/pageAbnormalReport")
    public Result<PageData<CollectLineReportVO>> pageAbnormalReport(@RequestBody @Validated CarrierPageCollectAbnormalReportParam param) {
        IPage<CollectLineReportVO> page = collectLineReportService.carrierPageAbnormalReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }
    @Operation(summary = "异常上报审核", description = "<br>By:艾庆国")
    @PostMapping("/updateAbnormalReportAudit")
    public Result<Void> updateAbnormalReportAudit(@RequestBody @Validated CollectLineReportSendAddressAuditParam param) {
        collectLineReportService.updateAbnormalReportAudit(param);

        return Result.ok();
    }

    @Operation(summary = "分页查询无接单上报列表",description = "<br>By:艾庆国")
    @PostMapping("/pageNoTakeOrderReport")
    public Result<PageData<CollectLineReportVO>> pageNoTakeOrderReport(@RequestBody @Validated CarrierPageCollectNoTakeOrderReportParam param) {
        IPage<CollectLineReportVO> page = collectLineReportService.carrierPageNoTakeOrderReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }
    @Operation(summary = "无接单上报审核", description = "<br>By:艾庆国")
    @PostMapping("/updateNoTakeOrderReportAudit")
    public Result<Void> updateNoTakeOrderReportAudit(@RequestBody @Validated CollectLineReportSendAddressAuditParam param) {
        collectLineReportService.updateNoTakeOrderReportAudit(param);

        return Result.ok();
    }

    @Operation(summary = "分页查询煤炭质量上报列表",description = "<br>By:艾庆国")
    @PostMapping("/pageQualityReport")
    public Result<PageData<CollectLineReportVO>> pageQualityReport(@RequestBody @Validated CarrierPageCollectQualityReportParam param) {
        IPage<CollectLineReportVO> page = collectLineReportService.carrierPageQualityReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }
    @Operation(summary = "煤炭质量上报审核", description = "<br>By:艾庆国")
    @PostMapping("/updateQualityReportAudit")
    public Result<Void> updateQualityReportAudit(@RequestBody @Validated CollectLineReportSendAddressAuditParam param) {
        collectLineReportService.updateQualityReportAudit(param);

        return Result.ok();
    }

    @Operation(summary = "分页查询其它上报列表",description = "<br>By:艾庆国")
    @PostMapping("/pageOtherReport")
    public Result<PageData<CollectLineReportVO>> pageOtherReport(@RequestBody @Validated CarrierPageCollectOtherReportParam param) {
        IPage<CollectLineReportVO> page = collectLineReportService.carrierPageOtherReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
