package com.clx.performance.controller.pc;

import com.clx.performance.service.OrderGoodsWeightService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import jakarta.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * @ClassName OrderWeightController
 * @Description
 * @Author kavin
 * @Date 2024/8/5 11:45
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/pc/orderGoods/weight")
@Validated
@Tag(name = "货单量查询")
@AllArgsConstructor
public class OrderGoodsWeightController {

    private final OrderGoodsWeightService orderGoodsWeightService;


    @Operation(summary = "查询货单可提取量",description = "<br>By:刘海泉")
    @GetMapping("/getOrderGoodsCanExtractWeight")
    public Result<BigDecimal> getOrderGoodsCanExtractWeight(@RequestParam("orderGoodsNo")
    @NotBlank(message = "货单编号不能为空") String orderGoodsNo) {
        return Result.ok(orderGoodsWeightService.getOrderGoodsCanExtractWeight(orderGoodsNo));
    }

}
