package com.clx.performance.controller.open;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.model.OwnerTransferInfo;
import com.clx.performance.param.open.OpenOwnerBindCardParam;
import com.clx.performance.param.open.OpenOwnerCaseOutParam;
import com.clx.performance.param.open.OpenOwnerTopUpParam;
import com.clx.performance.param.pc.*;
import com.clx.performance.param.pc.owner.CreteAccountParam;
import com.clx.performance.param.pc.owner.FrozenAccountParam;
import com.clx.performance.service.*;
import com.clx.performance.vo.pc.*;
import com.clx.user.vo.pc.owner.OwnerBindCardVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/open/owner")
@Validated
@AllArgsConstructor
@Tag(name = "PC-货主资金管理")
public class OpenOwnerAccountController {

    private final OwnerAccountService ownerAccountService;


    @Operation(summary = "账户充值", description = "<br>By:胡宇帆")
    @PostMapping("/accountTopUp")
    @UnitCovert(param = false)
    public Result<Long> openAccountTopUp(@RequestBody @Validated OpenOwnerTopUpParam param) {
        Long id = ownerAccountService.openAccountTopUp(param);
        return Result.ok(id);
    }

    @Operation(summary = "账户提现", description = "<br>By:胡宇帆")
    @PostMapping("/accountCaseOut")
    @UnitCovert(param = false)
    public Result<Long> accountCaseOut(@RequestBody OpenOwnerCaseOutParam param) {
        Long id = ownerAccountService.openAccountCaseOut(param);
        return Result.ok(id);
    }

    @Operation(summary = "获取货主信息绑卡信息", description = "<br>By:胡宇帆")
    @GetMapping("/getOwnerBindCard")
    public Result<OwnerBindCardVO> getOwnerBindCard(@RequestParam Long userNo) {
        return Result.ok(ownerAccountService.getOwnerBindCard(userNo));
    }

    @Operation(summary = "绑定货主银行卡")
    @PostMapping({"/bindOwnerBindCard"})
    Result<Object> openBindOwnerBindCard(@RequestBody OpenOwnerBindCardParam param) {
        ownerAccountService.openBindOwnerBindCard(param);
        return Result.ok();
    }

    @Operation(summary = "解绑货主银行卡")
    @PostMapping({"/unBindOwnerBindCard"})
    Result<Object> unBindOwnerBindCard(@RequestBody OpenOwnerBindCardParam param) {
        ownerAccountService.openUnBindOwnerBindCard(param);
        return Result.ok();
    }

}
