package com.clx.performance.controller.feign;

import com.clx.performance.service.OrderWeightService;
import com.clx.performance.vo.feign.OrderExtractWeightVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import jakarta.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * @ClassName OrderWeightController
 * @Description
 * @Author kavin
 * @Date 2024/8/5 11:45
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/feign/order/weight")
@Validated
@Tag(name = "订单量查询")
@AllArgsConstructor
public class OrderWeightFeignController {

    private final OrderWeightService orderWeightService;


    @Operation(summary = "查询订单可提取量",description = "<br>By:刘海泉")
    @GetMapping("/getOrderCanExtractWeight")
    public Result<OrderExtractWeightVO> getOrderCanExtractWeight(@RequestParam("orderNo")
    @NotBlank(message = "订单编号不能为空") String orderNo) {
        return Result.ok(orderWeightService.getOrderCanExtractWeight(orderNo));
    }

    @Operation(summary = "查询订单剩余量",description = "<br>By:刘海泉")
    @GetMapping("/getOrderResidueWeight")
    public Result<BigDecimal> getOrderResidueWeight(@RequestParam("orderNo")
    @NotBlank(message = "订单编号不能为空") String orderNo) {
        return Result.ok(orderWeightService.getOrderResidueWeight(orderNo));
    }


    @Operation(summary = "查询订单已拉运量",description = "<br>By:刘海泉")
    @GetMapping("/getAlreadyWeight")
    public Result<BigDecimal> getAlreadyWeight(@RequestParam("orderNo")
    @NotBlank(message = "订单编号不能为空") String orderNo) {
        return Result.ok(orderWeightService.getAlreadyWeight(orderNo));
    }



}
