package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.CollectTruckLeaveSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckLeaveParam;
import com.clx.performance.service.collect.CollectTruckLeaveService;
import com.clx.performance.vo.pc.collect.CollectTruckLeaveVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/app/driver/collect/leave")
@Validated
@Tag(name = "APP-请假")
@AllArgsConstructor
public class AppDriverCollectTruckLeaveController {

    private final CollectTruckLeaveService collectTruckLeaveService;

    @Operation(summary = "新增请假", description = "<br>By:艾庆国")
    @PostMapping("/saveLeave")
    public Result<Void> saveLeave(@RequestBody @Validated CollectTruckLeaveSaveParam param) {
        collectTruckLeaveService.saveLeave(param);

        return Result.ok();
    }

    @Operation(summary = "查询请假详情", description = "<br>By:艾庆国")
    @GetMapping("/getInfo")
    public Result<CollectTruckLeaveVO> getInfo(Integer id) {

        return Result.ok(collectTruckLeaveService.getInfo(id));
    }

    @Operation(summary = "分页查询请假列表",description = "<br>By:艾庆国")
    @PostMapping("/pageLeave")
    @UnitCovert(param = false)
    public Result<PageData<CollectTruckLeaveVO>> pageLeave(@RequestBody @Validated PageCollectTruckLeaveParam param) {
        IPage<CollectTruckLeaveVO> page = collectTruckLeaveService.pageLeave(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
