package com.clx.performance.constant;

/**
 * @Author: aiqingguo
 * @Description: 线路预警-mq
 * @Date: 2023-10-19 15:10:10
 * @Version: 1.0
 */
public class RabbitKeyLineWarnConstants {

    private static final String PREFIX = "clx-performance.lineWarn.";
    private static final String EXCHANGE = ".exchange";
    private static final String QUEUE = ".queue";
    private static final String QUEUE_ROUTING_KEY = ".routing.key";
    private static final String DELAY_QUEUE = ".delay.queue";
    private static final String DELAY_ROUTING_KEY = ".delay.routing.key";
    private static final String DEAD_QUEUE = ".dead.queue";
    private static final String DEAD_ROUTING_KEY = ".dead.routing.key";

    private RabbitKeyLineWarnConstants() {
    }

    /**
     * 缺省交换机
     */
    public static final String DEFAULT_EXCHANGE = PREFIX +"default"+EXCHANGE;

    /**
     * 缺省延迟队列
     */
    public static final String DEFAULT_DELAY_QUEUE = PREFIX +"default"+DELAY_QUEUE;
    public static final String DEFAULT_DELAY_ROUTING_KEY = PREFIX +"default"+DELAY_ROUTING_KEY;
    public static final String DEFAULT_DEAD_QUEUE = PREFIX +"default"+DEAD_QUEUE;
    public static final String DEFAULT_DEAD_ROUTING_KEY = PREFIX +"default"+DEAD_ROUTING_KEY;

    /**
     * 新增
     */
    public static final String ORDER_GOODS_ADD_QUEUE = PREFIX +"orderGoods.add"+QUEUE;
    public static final String ORDER_GOODS_ADD_ROUTING_KEY = PREFIX +"orderGoods.add"+QUEUE_ROUTING_KEY;

    /**
     * 车辆预警
     */
    public static final String LINE_WARN_QUEUE = PREFIX +"line.warn"+QUEUE;
    public static final String LINE_WARN_ROUTING_KEY = PREFIX +"line.warn"+QUEUE_ROUTING_KEY;

    /**
     * 线路预警通知
     */
    public static final String LINE_WARN_NOTICE_QUEUE = PREFIX +"lineWarn.notice"+QUEUE;
    public static final String LINE_WARN_NOTICE_ROUTING_KEY = PREFIX +"lineWarn.notice"+QUEUE_ROUTING_KEY;

    /**
     * 线路上报
     */
    public static final String LINE_WARN_LINE_REPORT_QUEUE = PREFIX +"lineWarn.lineReport"+QUEUE;
    public static final String LINE_WARN_LINE_REPORT_ROUTING_KEY = PREFIX +"lineWarn.lineReport"+QUEUE_ROUTING_KEY;

    /**
     * 运单异常
     */
    public static final String LINE_WARN_ORDER_CHILD_WARN_QUEUE = PREFIX +"lineWarn.orderChildWarn"+QUEUE;
    public static final String LINE_WARN_ORDER_CHILD_WARN_ROUTING_KEY = PREFIX +"lineWarn.orderChildWarn"+QUEUE_ROUTING_KEY;

}
