package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.OwnerRunningWaterRecord;
import com.clx.performance.param.pc.PageAppPrepaidFreightAccountParam;
import com.clx.performance.param.pc.PageOwnerAccountRunningWaterParam;
import com.clx.performance.param.pc.PagePlatformMarginAccountParam;
import com.clx.performance.param.pc.PagePlatformPrepaidFreightAccountParam;
import com.clx.performance.sqlProvider.OwnerRunningWaterRecordSqlProvider;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 货主流水记录
 */
@Mapper
public interface OwnerRunningWaterRecordMapper extends BaseMapper<OwnerRunningWaterRecord> {

    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "marginAccountPageList")
    IPage<OwnerAccountRunningWaterRecordVO> marginAccountPageList(Page<OwnerAccountRunningWaterRecordVO> page, PagePlatformMarginAccountParam param);

    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "prepaidFreightAccountPageList")
    IPage<OwnerAccountRunningWaterRecordVO> prepaidFreightAccountPageList(Page<OwnerAccountRunningWaterRecordVO> page, PagePlatformPrepaidFreightAccountParam param);

    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "prepaidFreightOwnerAccountPageList")
    IPage<OwnerAccountRunningWaterRecordVO> prepaidFreightOwnerAccountPageList(Page<OwnerAccountRunningWaterRecordVO> page, PageAppPrepaidFreightAccountParam param);


    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "ownerAccountRunningWaterPageList")
    IPage<OwnerAccountRunningWaterRecordVO> ownerAccountRunningWaterPageList(Page<OwnerAccountRunningWaterRecordVO> page, PageOwnerAccountRunningWaterParam param);

    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "ownerAccountRunningWaterList")
    List<OwnerAccountRunningWaterRecordVO> ownerAccountRunningWaterList(@Param(value = "param") PageOwnerAccountRunningWaterParam param);

    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "prepaidFreightAccountList")
    List<OwnerAccountRunningWaterRecordVO> prepaidFreightAccountList(@Param(value = "param") PagePlatformPrepaidFreightAccountParam param);

    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "marginAccountList")
    List<OwnerAccountRunningWaterRecordVO> marginAccountList(@Param(value = "param") PagePlatformMarginAccountParam param);

}