package com.clx.performance.dao.impl;

import com.clx.performance.dao.LargeScreenAddressRouteDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.mapper.LargeScreenAddressRouteMapper;
import com.clx.performance.model.LargeScreenAddressRoute;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author kavin
 * Date 2023-11-22
 * Time 10:54
 */
@Repository
public class LargeScreenAddressRouteDaoImpl extends BaseDaoImpl<LargeScreenAddressRouteMapper, LargeScreenAddressRoute, Integer> implements LargeScreenAddressRouteDao {

    @Override
    public List<LargeScreenAddressRoute> getEntityByReceiveAddressIdAndSendAddressId(Integer receiveAddressId, Integer sendAddressId) {
        return baseMapper.selectList(lQrWrapper().eq(LargeScreenAddressRoute::getReceiveSystemAddressId, receiveAddressId)
                .eq(LargeScreenAddressRoute::getSendSystemAddressId, sendAddressId)
        );

    }
}
