package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.PageAppPrepaidFreightAccountParam;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/app/owner")
@Validated
@AllArgsConstructor
@Api(tags = "APP-货主资金管理")
public class AppOwnerAccountController {

    private final OwnerAccountService ownerAccountService;


    @ApiOperation(value = "APP货主流水", notes = "<br>By:胡宇帆")
    @PostMapping("/prepaidFreightOwnerAccountPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountRunningWaterRecordVO>> prepaidFreightOwnerAccountPageList(@RequestBody PageAppPrepaidFreightAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerAccountService.prepaidFreightOwnerAccountPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }
}
