package com.clx.performance.model.vehiclewarn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 车辆预警运单表
* @Date: 2024/04/28 14:36:58
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class VehicleWarnChild  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String childNo;                         //运单编号
    private String orderGoodsNo;                    //货单编号
    private String truckNo;                         //车牌号
    private Long driverUserNo;                      //司机用户编号
    private BigDecimal sendLongitude;               //发货地址经度
    private BigDecimal sendLatitude;                //发货地址纬度
    private BigDecimal receiveLongitude;            //收货地址经度
    private BigDecimal receiveLatitude;             //收货地址纬度
    private Integer arriveSendExpectTime;           //预计到达货源地时间 （min）
    private Integer arriveReceiveExpectTime;        //预计到达目的地时间 （min）
    private LocalDateTime takeTime;                 //接单时间
    private Integer receiveAddressDistance;         //距离目的地距离（m）
    private LocalDateTime traceTime;                //轨迹更新时间
    private Integer traceStatus;                    //轨迹更新状态：0禁止 1启用
    private Integer wanStatus;                      //预警更新状态：0禁用 1启用
    private Integer status;                         //状态
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}