package com.clx.performance.dao.impl.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.vehiclewarn.VehicleWarnUserDao;
import com.clx.performance.enums.vehiclewarn.VehicleWarnUserEnum;
import com.clx.performance.mapper.vehiclewarn.VehicleWarnUserMapper;
import com.clx.performance.model.vehiclewarn.VehicleWarnUser;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnUserParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class VehicleWarnUserDaoImpl extends BaseDaoImpl<VehicleWarnUserMapper, VehicleWarnUser, Integer> implements VehicleWarnUserDao {

    @Override
    public boolean updateUser(VehicleWarnUser item) {
        return update(lUdWrapper()
                .eq(VehicleWarnUser::getId, item.getId())
                .set(VehicleWarnUser::getName, item.getName())
                .set(VehicleWarnUser::getMobile, item.getMobile())
        );
    }

    @Override
    public boolean deleteUser(VehicleWarnUser item) {
        return update(lUdWrapper()
                .eq(VehicleWarnUser::getId, item.getId())
                .set(VehicleWarnUser::getDeleteStatus, item.getDeleteStatus())
        );
    }

    @Override
    public boolean updateWarnType(VehicleWarnUser item) {
        return update(lUdWrapper()
                .eq(VehicleWarnUser::getId, item.getId())
                .set(VehicleWarnUser::getWarmTypeJson, item.getWarmTypeJson())
        );
    }

    @Override
    public Optional<VehicleWarnUser> findById(Integer id) {
        return Optional.of(id)
                .map(item -> lQrWrapper()
                        .eq(VehicleWarnUser::getId, id)
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public Optional<VehicleWarnUser> findByMobile(String mobile) {

        return Optional.of(mobile)
                .map(item -> lQrWrapper()
                        .eq(VehicleWarnUser::getMobile, mobile)
                        .eq(VehicleWarnUser::getDeleteStatus, VehicleWarnUserEnum.DeleteStatus.NO.getCode())
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public List<VehicleWarnUser> listAllEnable() {
        return list(lQrWrapper()
                .eq(VehicleWarnUser::getDeleteStatus, VehicleWarnUserEnum.DeleteStatus.NO.getCode())
        );
    }

    @Override
    public IPage<VehicleWarnUser> pageByParam(PageVehicleWarnUserParam param) {
        Page<VehicleWarnUser> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }
}
