package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeyVehicleWarnConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 货款往来明细 MQ
 * @Date: 2023-10-12 16:27:30
 * @Version: 1.0
 */
@Configuration
public class RabbitVehicleWarnConfig {

    @Bean
    public DirectExchange vehicleWarnDefaultExchange() {
        return new DirectExchange(RabbitKeyVehicleWarnConstants.DEFAULT_EXCHANGE);
    }

    @Bean
    public Queue vehicleWarnDefaultDelayQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-message-ttl", 15 * 60 * 1000);
        params.put("x-max-length", 5000000);
        params.put("x-dead-letter-exchange", RabbitKeyVehicleWarnConstants.DEFAULT_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeyVehicleWarnConstants.DEFAULT_DEAD_ROUTING_KEY);
        return new Queue(RabbitKeyVehicleWarnConstants.DEFAULT_DELAY_QUEUE, true, false, false, params);
    }
    @Bean
    public Binding vehicleWarnDefaultDelayQueueBinding() {
        return BindingBuilder.bind(vehicleWarnDefaultDelayQueue()).to(vehicleWarnDefaultExchange()).with(RabbitKeyVehicleWarnConstants.DEFAULT_DELAY_ROUTING_KEY);
    }

    @Bean
    public Queue vehicleWarnDefaultDeadQueue() {
        return new Queue(RabbitKeyVehicleWarnConstants.DEFAULT_DEAD_QUEUE);
    }
    @Bean
    public Binding vehicleWarnDefaultDeadQueueBinding() {
        return BindingBuilder.bind(vehicleWarnDefaultDeadQueue()).to(vehicleWarnDefaultExchange()).with(RabbitKeyVehicleWarnConstants.DEFAULT_DEAD_ROUTING_KEY);
    }


    /**
     * 新增
     */
    @Bean
    public Queue vehicleWarnChildAddQueue() {
        return new Queue(RabbitKeyVehicleWarnConstants.ORDER_CHILD_ADD_QUEUE);
    }
    @Bean
    public Binding vehicleWarnChildAddQueueBinding() {
        return BindingBuilder.bind(vehicleWarnChildAddQueue()).to(vehicleWarnDefaultExchange()).with(RabbitKeyVehicleWarnConstants.ORDER_CHILD_ADD_ROUTING_KEY);
    }

    /**
     * 车辆预警
     */
    @Bean
    public Queue vehicleWarnTruckWarnQueue() {
        return new Queue(RabbitKeyVehicleWarnConstants.TRUCK_WARN_QUEUE);
    }
    @Bean
    public Binding vehicleWarnTruckWarnQueueBinding() {
        return BindingBuilder.bind(vehicleWarnTruckWarnQueue()).to(vehicleWarnDefaultExchange()).with(RabbitKeyVehicleWarnConstants.TRUCK_WARN_ROUTING_KEY);
    }
    /**
     * 车辆预警
     */
    @Bean
    public Queue vehicleWarnNoticeQueue() {
        return new Queue(RabbitKeyVehicleWarnConstants.TRUCK_WARN_NOTICE_QUEUE);
    }
    @Bean
    public Binding vehicleWarnNoticeQueueBinding() {
        return BindingBuilder.bind(vehicleWarnNoticeQueue()).to(vehicleWarnDefaultExchange()).with(RabbitKeyVehicleWarnConstants.TRUCK_WARN_NOTICE_ROUTING_KEY);
    }

}
