package com.clx.performance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.IntegralOrderDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.IntegralOrder;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.pc.IntegralOrderAddParam;
import com.clx.performance.param.pc.pageIntegralOrderParam;
import com.clx.performance.service.IntegralOrderService;
import com.clx.performance.vo.pc.IntegralOrderVO;
import com.msl.common.exception.ServiceSystemException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
@Service
@AllArgsConstructor
public class IntegralOrderServiceImpl implements IntegralOrderService {

    private final IntegralOrderDao integralOrderDao;
    private final OrderGoodsDao orderGoodsDao;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void addOrder(IntegralOrderAddParam param) {
        String orderGoodsNo = param.getOrderGoodsNo();

        boolean existFlag = integralOrderDao.existByOrderGoodsNo(orderGoodsNo);
        if (existFlag) {throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_ORDER_EXIST);}

        OrderGoods orderGoods = orderGoodsDao.getByOrderGoodsNo(orderGoodsNo).orElseThrow(PerformanceResultEnum.ORDER_INVALID);

        IntegralOrder order = new IntegralOrder();
        order.setOrderGoodsNo(orderGoodsNo);
        order.setSendAddressId(orderGoods.getSendAddressId());
        order.setSendAddress(orderGoods.getSendAddressShorter());
        order.setReceiveAddressId(orderGoods.getReceiveAddressId());
        order.setReceiveAddress(orderGoods.getReceiveAddressShorter());
        order.setOrderType(param.getOrderType());
        order.setTruckEchelon(param.getTruckEchelon());
        integralOrderDao.saveEntity(order);
    }

    @Override
    public IPage<IntegralOrderVO> pageOrderList(pageIntegralOrderParam param) {
        return integralOrderDao.pageByParam(param);

    }
}
