package com.clx.performance.service.breakcontract;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.feign.OrderAdjustTonnageDownParam;
import com.clx.performance.param.pc.breakcontract.carrier.*;
import com.clx.performance.vo.pc.breakcontract.carrier.CarrierBreakContractSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerVO;
import com.clx.performance.vo.pc.owner.settle.SettlementPlatformAccountVO;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.math.BigDecimal;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
public interface BreakContractSettlementOwnerService  {

    IPage<PageCarrierBreakContractSettlementOwnerVO> pageCarrierBreakContractSettlementOwnerList(PageCarrierBreakContractSettlementOwnerParam param);


    SXSSFWorkbook exportCarrierBreakContractSettlementOwnerList(PageCarrierBreakContractSettlementOwnerParam param);

    CarrierBreakContractSettlementOwnerDetailVO getCarrierBreakContractSettlementOwnerDetail(String settlementNo);

    void uploadInvoiceImg(CarrierUploadInvoiceImgParam param);

    void updateCancelSettlement(CarrierCancelSettlementParam param);

    void saveCarrierBreakContractPayee(CarrierBreakContractSavePayeeParam param);

    void updateCarrierBreakContractPayeeConfirm(CarrierBreakPayeeConfirmParam param);

    void updateConfirmSettlement(OwnerConfirmSettlementParam param);

    void saveOwnerBreakContractPayee(CarrierBreakContractSavePayeeParam param);

    void updateOwnerBreakContractPayeeConfirm(CarrierBreakPayeeConfirmParam param);

    void saveSettlementOwnerForTonnageDown(OrderAdjustTonnageDownParam param);

    void saveSettlementOwnerForCancelOrder(BigDecimal transportWeight, BigDecimal validFreightPrice, String orderNo, Integer cancelType);

    SettlementPlatformAccountVO getCarrierSettlementPlatformAccount(Integer id);


}
