package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("senior_logistics_manager")
public class SeniorLogisticsManager implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("user_no")
    @ApiModelProperty("用户编号")
    private String userNo;

    @TableField("user_name")
    @ApiModelProperty("用户姓名")
    private String userName;

    @TableField("mobile")
    @ApiModelProperty("联系电话")
    private String mobile;

    @TableField("create_by")
    @ApiModelProperty("创建者编号")
    private Long createBy;

    @TableField("create_name")
    @ApiModelProperty("创建者姓名")
    private String createName;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
