package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 货主绑卡记录;
 *
 * @date : 2023-10-12
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_bind_card_record")
public class OwnerBindCardRecord implements HasKey<Integer> {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 货主编码
     */
    @TableField("owner_user_no")
    private Long ownerUserNo;
    /**
     * 货主名称
     */
    @TableField("owner_user_name")
    private String ownerUserName;
    /**
     * 货主类型;1:企业 2：个人
     */
//    @TableField("owner_type")
//    private Integer ownerType;
    /**
     * 货主银行
     */
    @TableField("owner_bank")
    private String ownerBank;
    /**
     * 银行卡号
     */
    @TableField("bank_card_number")
    private String bankCardNumber;
    /**
     * 开户行
     */
    @TableField("open_account_bank")
    private String openAccountBank;
    /**
     * 开户行号
     */
    @TableField("open_account_bank_number")
    private String openAccountBankNumber;
    /**
     * 户名
     */
    @TableField("account_bank_name")
    private String accountBankName;
    /**
     * 操作人
     */
    @TableField("create_by")
    private String createBy;
    /**
     * 操作项目
     */
    @TableField("create_item")
    private String createItem;
    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}