package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

/**
 * @author kavin
 * Date 2024-01-03
 * Time 10:17
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_child_sync_transport_invoice_record")
public class OrderChildSyncTransportInvoiceRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("child_no")
    @ApiModelProperty("运单编号")
    private String childNo;

    @TableField("remark")
    @ApiModelProperty("备注")
    private String remark;

    @TableField("type")
    @ApiModelProperty("备注 1: 未风控 2: 同步异常")
    private Integer type;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
