package com.clx.performance.mapper.loan;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.loan.BorrowerConfig;
import com.clx.performance.param.pc.loan.carrier.PageBorrowerConfigParam;
import com.clx.performance.sqlProvider.loan.BorrowerConfigSqlProvider;
import com.clx.performance.vo.pc.loan.carrier.BorrowerConfigVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

/**
* @Author: aiqinguo
* @Description: 借款配置
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@Mapper
public interface BorrowerConfigMapper extends BaseMapper<BorrowerConfig> {

    /**
     * @see BorrowerConfigSqlProvider#pageByParam(Page, PageBorrowerConfigParam)
     */
    @SelectProvider(type = BorrowerConfigSqlProvider.class, method = "pageByParam")
    IPage<BorrowerConfigVO> pageByParam(@Param("page") Page<BorrowerConfigVO> page, @Param("param") PageBorrowerConfigParam param);

}