package com.clx.performance.listener;

import cn.hutool.json.JSONUtil;
import com.clx.performance.param.OwnerBankNotifyMqParam;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.enums.nbbank.NbBankStatusEnum;
import com.clx.performance.service.loan.OwnerLoanAccountService;
import com.clx.performance.service.loan.OwnerLoanRecordService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 处理货主借款支付监听器
 */
@Slf4j
@Component
@AllArgsConstructor
public class OwnerLoanPayNotifyListener {

    private final OwnerLoanRecordService ownerLoanRecordService;

    private final OwnerLoanAccountService ownerLoanAccountService;

    @RabbitListener(queues = RabbitKeyConstants.OWNER_LOAN_PAY_QUEUE)
    public void onMessage(String message) {
        log.info("处理货主借款支付监听器执行,数据为{}", message);
        OwnerBankNotifyMqParam param = JSONUtil.toBean(message, OwnerBankNotifyMqParam.class);

        if (Objects.equals(param.getPayStatus(), NbBankStatusEnum.Status.SUCCESS.getCode())) {
            // 支付成功
            ownerLoanRecordService.paySuccess(param.getMerSeqNo());

        }
        else if (Objects.equals(param.getPayStatus(), NbBankStatusEnum.Status.FAIL.getCode())) {
            // 支付失败
            ownerLoanRecordService.payFail(param.getMerSeqNo());
        }
    }
}
