package com.clx.performance.dao.impl.loan;

import com.clx.performance.dao.loan.OrderChildLoanRetryRecordDao;
import com.clx.performance.mapper.loan.OrderChildLoanRetryRecordMapper;
import com.clx.performance.model.loan.OrderChildLoanRetryRecord;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author kavin
 * Date 2024-02-21
 * Time 19:58
 */
@Repository
public class OrderChildLoanRetryRecordDaoImpl extends BaseDaoImpl<OrderChildLoanRetryRecordMapper, OrderChildLoanRetryRecord, Integer> implements OrderChildLoanRetryRecordDao {

    @Override
    public List<OrderChildLoanRetryRecord> selectListByOwnerUserNoAndIdAsc(Long userNo) {
        return baseMapper.selectList(lQrWrapper().eq(OrderChildLoanRetryRecord::getOwnerUserNo, userNo).orderByAsc(OrderChildLoanRetryRecord::getId));
    }
}
