package com.clx.performance.controller.pc.breakcontract.carrier;

import com.clx.performance.param.pc.breakcontract.carrier.BreakContractDriveRuleUpdateParam;
import com.clx.performance.service.breakcontract.BreakContractDriverRuleService;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractDriverRuleVO;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract/driverRule")
@Validated
@Api(tags = "承运端-司机违约规则")
@AllArgsConstructor
public class CarrierBreakContractDriverRuleController {

    private final BreakContractDriverRuleService breakContractDriverRuleService;

    @ApiOperation(value = "更新司机违约规则", notes = "<br>By:艾庆国")
    @PostMapping("/updateRule")
    @UnitCovert()
    public Result<Void> updateRule(@RequestBody @Validated BreakContractDriveRuleUpdateParam param) {
        breakContractDriverRuleService.updateRule(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询规则详情", notes = "<br>By:艾庆国")
    @GetMapping("/getRuleInfo")
    public Result<BreakContractDriverRuleVO> getRuleInfo() {

        return Result.ok(breakContractDriverRuleService.getRuleInfo());
    }

}
