package com.clx.performance.controller.feign;

import cn.hutool.json.JSONUtil;
import com.clx.performance.param.pc.owner.FrozenAccountParam;
import com.clx.performance.param.pc.owner.ThawAccountParam;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.vo.pc.OwnerAccountAllVO;
import com.clx.performance.vo.pc.OwnerLoanAccountVO;
import com.msl.common.result.Result;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping("/feign/owner")
@Validated
@AllArgsConstructor
public class OwnerAccountFeignController {

    private final OwnerAccountService ownerAccountService;


    @ApiOperation(value = "冻结保证金和预付运费", notes = "<br>By:胡宇帆")
    @PostMapping("/ownerAccountFrozen")
    public Result<Object> ownerAccountFrozen(@RequestBody FrozenAccountParam param) {
        log.info("进行冻结保证金和预付运费,相关参数{}", JSONUtil.parse(param).toString());
        ownerAccountService.ownerAccountFrozen(param);
        return Result.ok();
    }

    @ApiOperation(value = "解冻保证金和预付运费", notes = "<br>By:胡宇帆")
    @PostMapping("/ownerAccountThaw")
    public Result<Object> ownerAccountThaw(@RequestBody ThawAccountParam param) {
        log.info("进行解冻保证金和预付运费账户,相关参数{}", JSONUtil.parse(param).toString());
        ownerAccountService.ownerAccountThaw(param);
        return Result.ok();
    }

    @ApiOperation(value = "查询用户预付运费和保证金账户", notes = "<br>By:胡宇帆")
    @GetMapping("/accountInfo")
    public Result<OwnerAccountAllVO> accountInfo(@RequestParam Long userNo) {
        return Result.ok(ownerAccountService.accountInfo(userNo));
    }

    @ApiOperation(value = "查询用户预付运费和保证金账户", notes = "<br>By:胡宇帆")
    @GetMapping("/loanAccount")
    public Result<OwnerLoanAccountVO> loanAccount(@RequestParam Long userNo) {
        return Result.ok(ownerAccountService.loanAccount(userNo));
    }
}
