package com.clx.performance.component;

import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.model.settle.SettlementOwner;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.param.feign.transport.OwnerSettlementSyncParam;
import com.clx.user.feign.OwnerFeign;
import com.msl.common.dto.HttpDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.LinkedList;
import java.util.List;

@Component
@Slf4j
@AllArgsConstructor
public class NetworkSyncComponent {

    private final TransportFeignService transportFeignService;

    private final OwnerFeign ownerFeign;


    public void ownerSettlementSync(SettlementOwner settlementOwner, List<SettlementOwnerDetail> settlementOwnerDetailList){
        //TODO 通知网络货运做货主计费开票标识通知
        OwnerSettlementSyncParam param = new OwnerSettlementSyncParam();
        String mobile = ownerFeign.getOwnerInfo(settlementOwner.getOwnerUserNo()).getData().getMobile();
        param.setOwnerMobile(mobile);
        List<OwnerSettlementSyncParam.SettlementItem> settlementList = new LinkedList<>();
        for (SettlementOwnerDetail settlementOwnerDetail : settlementOwnerDetailList) {
            String childNo = settlementOwnerDetail.getChildNo();
            OwnerSettlementSyncParam.SettlementItem  item = new OwnerSettlementSyncParam.SettlementItem();
            item.setChildNo(childNo);
            item.setSettlementNo(settlementOwnerDetail.getSettlementNo());
            settlementList.add(item);
        }
        param.setSettlementList(settlementList);
        HttpDTO httpDTO = transportFeignService.ownerSettlementSync(param);
        String decrypt = ThirdComponent.decrypt(httpDTO.getData());
        log.info("通知网络货运做货主计费开票标识通知请求解密后：{}", decrypt);
    }
}
