package com.clx.performance.param.mq;

import lombok.*;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @Author: aiqingguo
 * @Description: 运单结束
 * @Date: 2023-10-11 17:30:05
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class IntegralOrderChildFinishMqParam {
    
    private String childNo;                         //运单编号
    private Integer type;                           //类型：

    @Getter
    @AllArgsConstructor
    public enum Type {

        ARRIVE_SEND_ADDRESS_TIMEOUT_CANCEL(11, "到达货源地超时取消"),
        ARRIVE_RECEIVE_ADDRESS_TIMEOUT(12, "到达目的地超时"),
        DRIVER_CONFIRM(13, "司机确认收货"),
        DRIVER_CANCEL(14, "司机取消"),

        CARRIER_CANCEL(21, "承运取消"),
        ARTIFICIAL_CANCEL(22, "客服取消"),
        ORDER_CANCEL(23, "订单取消"),
        ORDER_GOODS_CANCEL(24, "货单取消"),

        ;

        private final Integer code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }
    }


}
