package com.clx.performance.param.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @Author:liumingchao
 * @Date:2022/11/4 13:50
 */
@Getter
@Setter
@NoArgsConstructor
public class OrderChildTruckTraceDTO {

    @ApiModelProperty(value = "运单号", required = true)
    private String childNo;
    @ApiModelProperty(value = "定位时间", required = true)
    @NotBlank(message = "定位时间不能为空")
    private String locationTime;
    @ApiModelProperty(value = "定位经度", required = true)
    @NotBlank(message = "定位经度不能为空")
    private String locationLon;
    @ApiModelProperty(value = "定位纬度", required = true)
    @NotBlank(message = "定位纬度不能为空")
    private String locationLat;
    @ApiModelProperty(value = "定位详细位置信息")
    private String locationAddress;

}
