package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum TransportSyncTypeEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {

        NO_PASS(1, "未通过风控异常"),
        EXCEPTION(2, "同步异常"),

        ;

        private final Integer code;
        private final String msg;

        public static Optional<Type> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static Optional<Type> getByName(String name) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getMsg(), name)).findFirst();
        }

        public static Integer getCodeByName(String name) {
            return getByName(name).map(TransportSyncTypeEnum.Type::getCode).orElse(3);
        }
    }


}
