package com.clx.performance.sqlProvider.vehiclewarn;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnConfigParam;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnInfoParam;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class VehicleWarnInfoSqlProvider {

    private static final String TABLE = "vehicle_warn_info";

    public String pageByParam(@Param("page") Page page, @Param("param") PageVehicleWarnInfoParam param) {

        return new SQL(){{

            SELECT("*");
            FROM(TABLE);

            if (StringUtils.isNotBlank(param.getWarnName())) {WHERE("warn_name = #{param.warnName}");}
            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (Objects.nonNull(param.getWarnType())) {WHERE("warn_type = #{param.warnType}");}
            if (Objects.nonNull(param.getWarnLevel())) {WHERE("warn_level = #{param.warnLevel}");}
            if (Objects.nonNull(param.getStatus())) {WHERE("status = #{param.status}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("id desc");
        }}.toString();
    }

}
