package com.clx.performance.service.impl.trace;

import com.clx.performance.esplus.mapper.DriverTraceESPlusMapper;
import com.clx.performance.esplus.mapper.TruckTraceESPlusMapper;
import com.clx.performance.esplus.model.DriverTraceESPlus;
import com.clx.performance.esplus.model.TruckTraceESPlus;
import com.clx.performance.param.temp.DriverTraceAddParam;
import com.clx.performance.param.temp.TruckTraceAddParam;
import com.clx.performance.service.trace.TruckTraceService;
import com.clx.performance.struct.trace.DriverTraceStruct;
import com.clx.performance.struct.trace.TruckTraceStruct;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.pc.trace.DriverTraceVO;
import com.clx.performance.vo.pc.trace.DriverTruckTraceVO;
import lombok.extern.slf4j.Slf4j;
import org.dromara.easyes.core.conditions.select.LambdaEsQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class TruckTraceServiceImpl implements TruckTraceService {

    @Autowired
    private TruckTraceESPlusMapper truckTraceESPlusMapper;
    @Autowired
    private DriverTraceESPlusMapper driverTraceESPlusMapper;

    @Autowired
    private TruckTraceStruct truckTraceStruct;
    @Autowired
    private DriverTraceStruct driverTraceStruct;

    @Override
    public List<DriverTruckTraceVO> listTruckTraceByTime(String truckNo, String beginTime, String endTime) {
        List<TruckTraceESPlus> list = truckTraceESPlusMapper.selectList(new LambdaEsQueryWrapper<TruckTraceESPlus>()
                .eq(TruckTraceESPlus::getTruckNo, truckNo)
                .ge(TruckTraceESPlus::getGpsTime, beginTime)
                .le(TruckTraceESPlus::getGpsTime, endTime)
                .orderByAsc("gpsTime")
        );

        List<DriverTruckTraceVO> truckTraceList = truckTraceStruct.convert(list);

        // 停留时长计算

        return truckTraceList;
    }

    @Override
    public List<DriverTraceVO> listDriverTraceByTime(Long userNo, String beginTime, String endTime) {
        List<DriverTraceESPlus> list = driverTraceESPlusMapper.selectList(new LambdaEsQueryWrapper<DriverTraceESPlus>()
                .eq(DriverTraceESPlus::getUserNo, userNo)
                .ge(DriverTraceESPlus::getPositionTime, beginTime)
                .le(DriverTraceESPlus::getPositionTime, endTime)
                .orderByAsc("positionTime")
        );

        List<DriverTraceVO> truckTraceList = driverTraceStruct.convert(list);
        // 停留时长计算

        return truckTraceList;
    }


    @Override
    public void truckTraceSave(TruckTraceAddParam param){

        List<TruckTraceESPlus> list = new ArrayList<>();
        for (TruckTraceAddParam.TruckTraceItem item : param.getTraceList()) {
            TruckTraceESPlus es = new TruckTraceESPlus();
            es.setTruckNo(item.getTruckNo());
            es.setAngle(item.getAngle());
            es.setHeight(item.getHeight());
            es.setLocation(item.getLocation());
            es.setGpsTime(item.getGpsTime());
            es.setMileage(item.getMileage());
            es.setSpeed(item.getSpeed());
            es.setCreateTime(LocalDateTimeUtils.formatTime());

            list.add(es);
        }

        truckTraceESPlusMapper.insertBatch(list);
    }
    @Override
    public void driverTraceSave(DriverTraceAddParam param){

        List<DriverTraceESPlus> list = new ArrayList<>();
        for (DriverTraceAddParam.DriverTraceItem item : param.getTraceList()) {
            DriverTraceESPlus es = new DriverTraceESPlus();
            es.setUserNo(item.getUserNo());
            es.setDataType(item.getDataType());
            es.setLocation(item.getLocation());
            es.setPositionTime(item.getGpsTime());
            es.setCreateTime(LocalDateTimeUtils.formatTime());
            es.setModifiedTime(es.getCreateTime());

            list.add(es);
        }

        driverTraceESPlusMapper.insertBatch(list);
    }

}
