package com.clx.performance.model.vehiclewarn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 车辆预警信息表
* @Date: 2024/04/25 13:24:56
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class VehicleWarnInfo  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Integer warnConfigId;                   //预警配置id
    private String warnName;                        //预警名称
    private Integer warnType;                       //预警类型
    private Integer warnLevel;                      //预警级别
    private String childNo;                         //运单编号
    private Integer sendAddressId;                  //发货地址id
    private String sendAddress;                     //发货地址
    private Integer receiveAddressId;               //收货地址id
    private String receiveAddress;                  //收货地址
    private Integer childStatus;                    //运单状态
    private Integer truckId;                        //车辆ID
    private String truckNo;                         //车牌号
    private Long driverUserNo;                      //司机用户编号
    private String driverName;                      //司机姓名
    private String driverMobile;                    //司机手机号
    private LocalDateTime takeTime;                 //接单时间
    private LocalDateTime warnTime;                 //预警时间
    private Integer status;                         //处理状态：1待处理 2已处理 3暂停预警
    private String createBy;                        //创建人
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间
    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
