package com.clx.performance.dao.impl.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.vehiclewarn.VehicleWarnInfoDao;
import com.clx.performance.mapper.vehiclewarn.VehicleWarnInfoMapper;
import com.clx.performance.model.vehiclewarn.VehicleWarnInfo;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnInfoParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

@Repository
public class VehicleWarnInfoDaoImpl extends BaseDaoImpl<VehicleWarnInfoMapper, VehicleWarnInfo, Integer> implements VehicleWarnInfoDao {

    @Override
    public boolean updateStatus(VehicleWarnInfo item) {
        return update(lUdWrapper()
                .eq(VehicleWarnInfo::getId, item.getId())
                .set(VehicleWarnInfo::getStatus, item.getStatus())
        );
    }

    @Override
    public Optional<VehicleWarnInfo> findById(Integer id) {
        return Optional.of(id)
                .map(item -> lQrWrapper()
                        .eq(VehicleWarnInfo::getId, id)
                        .last("limit 1")
                )
                .map(super::getOne);
    }


    @Override
    public IPage<VehicleWarnInfo> pageByParam(PageVehicleWarnInfoParam param) {
        Page<VehicleWarnInfo> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

}
