package com.clx.performance.vo.app.collect;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 车辆信息上报
* @Date: 2023/11/07 11:11:41
* @Version: 1.0
*/

@ApiModel(description = "车辆信息上报")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class AppCollectTruckVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "车辆id", example = "")
    private Integer truckId;
    @ApiModelProperty(value = "车牌", example = "")
    private String truckNo;
    @ApiModelProperty(value = "卸车类型：1自卸侧翻 2自卸立翻 3非自卸", example = "")
    private Integer unloadType;

    @ApiModelProperty(value = "车贷状态：0无车贷 1有车贷", example = "")
    private Integer autoLoanStatus;
    @ApiModelProperty(value = "车贷剩余月份", example = "")
    private Integer autoLoanMonth;
    @ApiModelProperty(value = "车辆停放位置", example = "")
    private String parkAddress;
    @ApiModelProperty(value = "拉运方式：1标吨 2超吨 3白天标吨晚上超吨", example = "")
    private Integer overTunageType;
    @ApiModelProperty(value = "接受距常驻地最远距离（公里）", example = "")
    private Integer distanceUsualPlaceMax;
    @ApiModelProperty(value = "单次任务接受最远距离（公里）", example = "")
    private Integer distanceLineMax;
    @ApiModelProperty(value = "接受距货源地最远距离（公里）", example = "")
    private Integer distanceSendAddressMax;
    @ApiModelProperty(value = "拉运货物意愿：1块煤 2面煤 3煤泥", example = "")
    private String goodsType;

}