package com.clx.performance.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.clx.performance.component.ThirdComponent;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.settle.OrderChildSyncTransportRecordDao;
import com.clx.performance.dto.OrderChildSyncDTO;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.settle.OrderChildSyncTransportRecord;
import com.clx.performance.param.feign.transport.OrderChildPaySyncParam;
import com.clx.performance.service.settle.SettlementDriverDetailService;
import com.clx.performance.service.settle.SettlementMqHandlerService;
import com.clx.performance.service.settle.SettlementMqService;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.clx.performance.vo.mq.SettlementStatisticsMqParam;
import com.msl.common.dto.HttpDTO;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Component
@AllArgsConstructor
public class OrderChildPaySyncTransportJob {

    private final OrderChildSyncTransportRecordDao orderChildSyncTransportRecordDao;

    private final TransportFeignService transportFeignService;

    private final SettlementMqHandlerService settlementMqHandlerService;

    private final SettlementDriverDetailService settlementDriverDetailService;

    private final SettlementOwnerDetailService settlementOwnerDetailService;

    private final SettlementMqService settlementMqService;

    private final OrderChildDao orderChildDao;

    private final OrderGoodsDao orderGoodsDao;

    /**
     * 同步网络货运运单支付(禁用网络货运同步)
     */
//    @XxlJob("orderChildPaySyncTransportJob")
//    public void orderChildPaySyncTransportJob() {
//        List<OrderChildSyncTransportRecord> recordList = orderChildSyncTransportRecordDao.selectListForJob();
//        if (CollectionUtil.isEmpty(recordList)) {
//            return;
//        }
//
//        List<String> orderChilList = recordList.stream().map(OrderChildSyncTransportRecord::getChildNo).collect(Collectors.toList());
//        OrderChildPaySyncParam param = new OrderChildPaySyncParam();
//        param.setChildNoList(orderChilList);
//        HttpDTO httpDTO = transportFeignService.orderChildPaySync(param);
//        String decrypt = ThirdComponent.decrypt(httpDTO.getData());
//        OrderChildSyncDTO bean = JSONUtil.toBean(decrypt, OrderChildSyncDTO.class);
//        if (bean.getCode() == 0) {
//            for (OrderChildSyncTransportRecord record : recordList) {
//                OrderChildSyncTransportRecord update = new OrderChildSyncTransportRecord();
//                update.setId(record.getId());
//                update.setStatus(1);
//                orderChildSyncTransportRecordDao.updateEntityByKey(update);
//            }
//        }
//
//    }


    /**
     * 结算信息job处理
     * */
    @XxlJob("settlementDetailInvoiceTypeSyncJob")
    public void settlementDetailInvoiceTypeSyncJob() {
        String jobParam = XxlJobHelper.getJobParam();
        log.info("XxlJobHelper jobParam:{}", jobParam);
        SettlementStatisticsMqParam mqParam = new SettlementStatisticsMqParam();
        mqParam.setChildNo(jobParam);
        settlementMqHandlerService.settlementStatistics(mqParam);
    }


    @XxlJob("testJob")
    public void test2() {
        String jobParam = XxlJobHelper.getJobParam();
        log.info("XxlJobHelper jobParam:{}", jobParam);
        OrderChild orderChild = orderChildDao.getByChildNo(jobParam).get();
        OrderGoods orderGoods = orderGoodsDao.getByOrderGoodsNo(orderChild.getOrderGoodsNo()).get();
        Integer settlementDriverDetailId = settlementDriverDetailService.saveSettlementDetail(orderChild);
        Integer settlementOwnerDetailId = settlementOwnerDetailService.saveSettlementDetail(orderChild, orderGoods);

        settlementMqService.settlementDetailAdd(settlementDriverDetailId, settlementOwnerDetailId);

    }

}
