package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author yangqifa
 */
@Getter
@Setter
@NoArgsConstructor
public class OcrRecognitionParam {

    @ApiModelProperty(value = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @ApiModelProperty(value = "图片类型,1:装车磅单,2:卸车磅单")
    @NotNull(message = "图片类型不能为空")
    private Integer imageType;

    @ApiModelProperty(value = "磅单图片url")
    @NotBlank(message = "磅单图片url不能为空")
    private String imageUrl;

}
